#define LIGHTING
#include "InventorBasicEffectDx10.fxh"


struct VSPosNorm
{
	float3 Pos		: Position;
	float3 Norm		: Normal;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosNorm( VSPosNorm Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	Out.Pos = mul(LocalPos, g_matWorldViewProj);
	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	float3 Viewer = -normalize(ViewPos);                   //viewer
	float3 ViewNormal = mul(Input.Norm, (float3x3)g_matWorldViewIT); //normal in view space
	ViewNormal = normalize(ViewNormal);

#ifdef DIFFUSE_TEXTURE	
	//automatic texture coordinate generation
	Out.Tex += float4(Input.Pos*(g_texCoordType == TEX_COORD_POSITION), 1.0f);
	Out.Tex += float4(Input.Norm*(g_texCoordType == TEX_COORD_NORMAL), 0);
	Out.Tex += float4(ViewPos * (g_texCoordType == TEX_COORD_CAMERASPACEPOSITION), 0);
	Out.Tex += float4(ViewNormal * (g_texCoordType == TEX_COORD_CAMERASPACENORMAL), 0);
	Out.Tex += float4((2.f * dot(Viewer,ViewNormal) * ViewNormal - Viewer) * (g_texCoordType == TEX_COORD_CAMERASPACEREFLECTIONVECTOR), 0);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif

#ifdef ENVIRONMENT_TEXTURE	
	float3 VwNorm = normalize(mul(Viewer, (float3x3)transpose(g_matView)));
	float3 Nw = normalize(mul(ViewNormal, (float3x3)transpose(g_matView)));
	Out.EnvTex = float4(2.f * dot(VwNorm,Nw) * Nw - VwNorm, 1.0f);
	Out.EnvTex = mul(Out.EnvTex, g_matEnvTex);
#endif

	float Glossness = g_Misc.x;
	float Opacity = g_Misc.y;
	TripleColor Color = CalcLighting(Input.Pos, Viewer, ViewNormal, g_Emissive, g_Ambient, g_Diffuse, g_Specular, Glossness, Opacity
#ifdef SHADOWS
        , Out.ShadowD, Out.ShadowS
#endif
        );
	Out.ColorD = Color.Diffuse;
	Out.ColorS = Color.Specular;  
		
#ifdef SHADOWS
    Out.ShadowPos = mul(mul(LocalPos, g_matWorld), gShadowMapXf);
#endif

	if(g_fogEnabled)
	{
		Out.FogFactor =	CalcFogFactor(ViewPos.z);
	}
 	  
	//Apply user specified clipping
    	Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
    	Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
    	if( g_bClippingEnable )
    	{
		CalcClipping(LocalPos, Out);
    	}
	return Out;
}
//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_PosNorm( VSOutput Input ) : SV_Target
{
#ifdef SHADOWS
    float shadowFactor = SampleShadowMap(Input.ShadowPos);
    Input.ColorD += Input.ShadowD * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
    Input.ColorS += Input.ShadowS * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
#endif

#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
#endif

#ifdef ENVIRONMENT_TEXTURE	
	CalcEnvironmentTexture(Input,g_Specular,g_Misc.z);
#endif
	
	if(Input.ColorD.a < g_Misc.w)
		discard;

	float4 Color = saturate(Input.ColorD + Input.ColorS);

if(g_fogEnabled)
	return Input.FogFactor * Color + (1.0 - Input.FogFactor) * g_fogColor;
else
	return Color;
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------


technique10 PosNorm
{
 	pass P0
    	{   
		SetVertexShader( CompileShader( vs_4_0, VS_PosNorm()) );
        	SetGeometryShader( NULL );
        	SetPixelShader( CompileShader( ps_4_0, PS_PosNorm()) );
	}
}